package org.msh.tb.bd.dashboard.detailedrep;

import org.jboss.seam.annotations.Name;
import org.jboss.seam.international.Messages;
import org.msh.tb.bd.dashboard.DashboardIndicatorUtils;
import org.msh.tb.bd.dashboard.query.Indicator11Query;
import org.msh.tb.entities.AdministrativeUnit;
import org.msh.tb.indicators.core.IndicatorTable;
import org.msh.tb.login.UserSession;
import org.msh.utils.date.DateUtils;
import org.msh.utils.date.Period;
import org.msh.utils.reportgen.highchart.ChartCreator;
import org.msh.utils.reportgen.highchart.ChartOptions;
import org.msh.utils.reportgen.highchart.Series;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

/**
 * Created by Mauricio on 19/05/2017.
 */
@Name("detailedIndicator11")
public class DetailedIndicator11 extends DetailedIndicator<Indicator11Query> {

    @Override
    protected void createIndicators() {
        AdministrativeUnit auSelected = getIndicatorFilters().getTbunitselection().getAuselection().getSelectedUnit();

        // set params to indicator query
        getQuery().setIniDate(getIndicatorFilters().getIniDate());
        getQuery().setEndDate(getIndicatorFilters().getEndDate());
        getQuery().setSelectedAdminUnit(auSelected);

        List<Object[]> result = getQuery().getDetailedResult();

        // check root name
        String rootLabel = auSelected == null ? "Bangladesh" : auSelected.getCountryStructure().getName() + ": " + auSelected.getName().getName1();

        // populate indicator table
        for(Object[] r : result){
            String adminUnit = (String) r[0];
            Long tb10CaseQtt = (Long) r[1];
            Long tb10ManualPresentation = (Long) r[2];
            Float rate1 = (Float) r[3];
            Float rate2 = (Float) r[4];

            if (adminUnit.equals("root")) {
                adminUnit = rootLabel;
            }

            if (adminUnit.equals(rootLabel) || (tb10CaseQtt != null && tb10CaseQtt > 0) || (tb10ManualPresentation != null && tb10ManualPresentation > 0)) {
                addValue(getMessage("dashboard.indicator11.tb10cases"), adminUnit, tb10CaseQtt != null ? tb10CaseQtt.floatValue() : 0);
                addValue(getMessage("dashboard.indicator11.manualprescases"), adminUnit, tb10ManualPresentation != null ? tb10ManualPresentation.floatValue() : 0);
                addValue(getMessage("dashboard.indicator11.rate"), adminUnit, rate1);
                addValue(getMessage("dashboard.indicator11.rate2"), adminUnit, adminUnit.equals(rootLabel) ? null : rate2);
            }
        }

        // set highlight in root row
        getTable().getRows().get(getTable().getRows().size()-1).setHighlight(true);
    }


    @Override
    protected Indicator11Query getQueryNewInstance() {
        return new Indicator11Query();
    }

    /**
     * Create data to be generated by the chart
     */
    protected void createChartData() {
        if (getTable() == null)
            return;

        chartCreator = new ChartCreator();
        ChartOptions opt = chartCreator.getOptions();
        opt.getChart().setRenderTo("chartdiv");
        opt.getChart().setType(getIndicatorFilters().getHighChartType());
        Series series = opt.addSeries();

        String rateColumnLabel = Messages.instance().get("dashboard.indicator11.rate");
        series.setName(rateColumnLabel);

        for (IndicatorTable.TableRow row: getTable().getRows()) {
            for (IndicatorTable.TableCell cell: row.getCells()) {
                if (cell.getColumn().getTitle() != null && cell.getColumn().getTitle().equals(rateColumnLabel) && cell.getValue() > 0) {
                    BigDecimal bd = new BigDecimal(cell.getValue().doubleValue()).setScale(2, RoundingMode.HALF_EVEN);
                    series.addNewValue(bd.doubleValue());
                    opt.getxAxis().getCategories().add(cell.getRow().getTitle());
                }
            }
        }

        opt.getTitle().setText(Messages.instance().get("dashboard.indicator11"));
    }
}
